/*****************************************************************************/
/* File         libibm.h                                                     */
/*                                                                           */
/* Purpose      General include file for the LIBIBM routines                 */
/*                                                                           */
/* Tested       26 APR 90       OS/2    IBM C2 1.1                           */
/*              26 APR 90       VM      C/370                                */
/*              26 APR 90       VM      Whitesmiths                          */
/*              26 APR 90       AIX 2.2 RT                                   */
/*              22 MAY 90       AIX 1.2 PS/2                                 */
/*              18 AUG 90       DOS/4680 MetaWare C                          */
/*              17 SEP 90       AIX     S/6000                               */
/*              17 JUL 91       AIX     S/6000 C++                           */
/*              25 JUL 91       OS/2 2  CL386                                */
/*              17 AUG 91       OS/2 2  IBM C Set/2                          */
/*              20 OCT 91       TOS     ATC                                  */
/*              17 DEC 91       GNU CC  S/6000                               */
/*                                                                           */
/* Author       Tim Bell (BELLTG at WINVMB)                                  */
/*                                                                           */
/* History                                                                   */
/*   20-Oct-91 AM   Added undefs before CC_ and OS_ defines.                 */
/*                  Added support for Atari ST.                              */
/*   11-Nov-91 TGB  Added TOKEN_PASTE macro                                  */
/*   17-Mar-92 TGB  Added conditional test around _CHAR_UNSIGNED             */
/*   17-Mar-92 TGB  Removed C-LSRCH function types and moved to C-LSRCH      */
/*   13-Apr-92 TGB  Added C++ START_C_SOURCE and END_C_SOURCE macros         */
/*****************************************************************************/
#ifndef _H_LIBIBM                                          /* Stop multiple  */
#define _H_LIBIBM

/*****************************************************************************/
/* Compilers supported                                                       */
/*                                                                           */
/* a) No command line options required                                       */
/*    If two OS are named in the OS_ column, the first one is the default.   */
/*                                                                           */
/*                                                        CC_...    OS_...   */
/*                                                                           */
/*      AIX 2.2 PCC compiler                              PCC       AIX2_2   */
/*      AIX 3.0 XLC compiler                              XLC       AIX3_0   */
/*      IBM C/2 1.1                                       IDK       DOS|OS2  */
/*                                                        MS                 */
/*      IBM C Set/2 for OS/2 2.0                          IBMC386   OS2_2    */
/*      Turbo C                                           TURBO     DOS      */
/*                                                        TC                 */
/*      AIX 1.2 CC compiler                               PS2CC     AIX1_2   */
/*      MetaWare C compiler                               MW        DOS      */
/*      Turbo C for Atari ST                              ATC       TOS      */
/*      GNU C for AIX 3.0                                 GNU       AIX3_0   */
/*                                                                           */
/* b) Command line option required                                           */
/*      Whitesmiths Ltd C 370 Program Offering            WS        VM|MVS   */
/*       Compile with                                                        */
/*         CC <fn> <ft> ( define(CC_WS)                                      */
/*                                                                           */
/*      IBM C/370                                         C370      VM|MVS   */
/*       Compile with                                                        */
/*         CC <fn> <ft> ( define(CC_C370)                                    */
/*****************************************************************************/
/*****************************************************************************/
/* Configuration Definitions                                                 */
/*                                                                           */
/* bool_t                A boolean type                                      */
/*                        This can be either TRUE or FALSE                   */
/* byte_t                A byte type                                         */
/*                        This can be a value between 0 and 255              */
/* uint32_t              A 32 bit unsigned integer type                      */
/*                        This can be a value between 0 and 2^32-1           */
/* int32_t              A 32 bit signed integer type                         */
/*                        This can be a value between -2^31 and 2^31-1       */
/* uint16_t             A 16 bit unsigned integer type                       */
/*                        This can be a value between 0 and 2^16-1           */
/* int16_t              A 16 bit signed integer type                         */
/*                        This can be a value between -2^15 and 2^15-1       */
/* void_ptr_t           A void * type.  For compilers that do not support    */
/*                        void pointers, this will be defined as char *      */
/* _NO_PROTO            If defined, this indicates that no prototypes are    */
/*                        supported.                                         */
/* _CHAR_UNSIGNED       If defined, this indicates that characters are       */
/*                        unsigned.  Otherwise, characters are assumed to    */
/*                        be signed                                          */
/* NO_EXT_KEYS          If defined, this means that the keywords 'near' and  */
/*                        'far' are not supported                            */
/* _MACHINE             A text string identifying the system that is         */
/*                        compiling                                          */
/* _BIG_ENDIAN          If defined, this means that integers are stored      */
/*                        high byte first.  If not defined, means that       */
/*                        integers are stored low byte first                 */
/* SHORT_EXTERN_NAMES   The external names are 8 characters maximum.  This   */
/*                        causes a lot of code to fail to compile as many C  */
/*                        compilers allow 32 external characters for names   */
/*                        This flag allows a series of macros to be set up   */
/*                        to convert between mnemonic names and short ones   */
/* START_C_SOURCE       Protects the source code from C++ name mangling      */
/* END_C_SOURCE           rules.  This means that C source code will be      */
/*                        treated as such                                    */
/*****************************************************************************/
/*****************************************************************************/
/* Inclusion Control                                                         */
/*                                                                           */
/* Some compilers have different include files for different purposes.       */
/* This can make writing portable code very difficult without a confusing    */
/* mass of #if / #include lists at the beginning of the files                */
/*                                                                           */
/* To reduce this complexity, the following macros can be provided to        */
/* specify what include files should be included                             */
/*                                                                           */
/* INCL_STDIO       Include all the stream definitions etc.                  */
/* INCL_STRING      Include declarations for strcpy() etc.                   */
/* INCL_MEMORY      Include declarations for memcpy() etc.                   */
/* INCL_STDLIB      Include declarations for the ANSI C contents of stdlib.h */
/* INCL_STDDEF      Include declarations for the ANSI C contents of stddef.h */
/* INCL_LIMITS      Include declarations for the ANSI C contents of limits.h */
/* INCL_STDARG      Include declarations for the ANSI C contents of stdarg.h */
/* INCL_ERRNO       Include declarations for errno and associated defines    */
/* INCL_CTYPE       Include declarations for the ANSI C contents of ctype.h  */
/*****************************************************************************/
typedef unsigned char bool_t;
typedef unsigned char byte_t;
typedef unsigned char uint8_t;

#if defined(aiws) && !defined(_I386)
/*****************************************************************************/
/* AIX V2.2 on the RT                                                        */
/*****************************************************************************/
typedef unsigned long uint32_t;
typedef long int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef byte_t *void_ptr_t;

#if defined(CC_PCC)
#undef  CC_PCC
#endif
#define CC_PCC              (1)                 /* Compiler used             */
#define _NO_PROTO           (1)                 /* Prototypes supported      */
#if defined(OS_AIX2_2)
#undef  OS_AIX2_2
#endif
#define OS_AIX2_2           (1)                 /* Operating system          */
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                 /* Are characters unsigned   */
#endif
#define NO_EXT_KEYS                             /* Near / Far supported      */
#define _MACHINE             "RT"               /* Machine string            */
#define _BIG_ENDIAN                             /* Integers stored hi..lo    */

/*****************************************************************************/
/* AIX 2.2 does not have a stdlib.h file, so if stdlib is asked for, we      */
/* have to emulate it                                                        */
/*****************************************************************************/
#if defined(INCL_STDLIB)
void_ptr_t malloc();
void       free();                                         /* No <stdlib.h>  */
void_ptr_t realloc();
void_ptr_t calloc();
char      *getenv();
void       exit();
double     atof();
int        atoi();
long       atol();
int        rand();
void       srand();
int        system();
void       abort();
#undef INCL_STDLIB
#endif

/*****************************************************************************/
/* AIX 2.2 has some functions in stdio.h with different names and some       */
/* functions missing from stdio.h                                            */
/*****************************************************************************/
#if defined(INCL_STDIO)
#define remove unlink
void perror();
#endif

#if defined(INCL_LIMITS)
#define CHAR_MAX                 255
#define CHAR_MIN                 0
#define SCHAR_MAX                127          /* maximum signed char value   */
#define SCHAR_MIN               -127          /* minimum signed char value   */
#define UCHAR_MAX                255          /* maximum unsigned char value */
#define CHAR_BIT                 8            /* number of bits in a char    */
#define USHRT_MAX                0xffff       /* maximum unsigned short value*/
#define SHRT_MAX                 32767        /* maximum (signed) short value*/
#define SHRT_MIN                -32767        /* minimum (signed) short value*/
#define UINT_MAX                 0xffffffff   /* maximum unsigned int value  */
#define ULONG_MAX                0xffffffff   /* maximum unsigned long value */
#define INT_MAX                  2147483647   /* maximum (signed) long value */
#define INT_MIN                 -2147483647   /* minimum (signed) long value */
#define LONG_MAX                 2147483647   /* maximum (signed) long value */
#define LONG_MIN                -2147483647   /* minimum (signed) long value */
#undef  INCL_LIMITS
#endif

#if defined(INCL_STDDEF)
typedef int size_t;
#undef INCL_STDDEF
#endif

/*****************************************************************************/
/* AIX 2.2 does not include a definition of strcmp() in the string.h file    */
/*****************************************************************************/
#if defined(INCL_STRING)
int strcmp();
int strncmp();
int strlen();

/*****************************************************************************/
/* string.h does not have a definition of strdup                             */
/*****************************************************************************/
#if defined(INCL_STRING)
#define strdup(s) (strcpy((char *)malloc(strlen(s)+1),s))
#endif

/*****************************************************************************/
/* PCC is not an ANSI compiler so token pasting uses comments                */
/*****************************************************************************/
#define TOKEN_PASTE(a,b) a/**/b
#define TOKEN_QUOTE(a)   "a"

#endif

/*****************************************************************************/
/* RT does not have the lseek macros defined in stdio.h ...                  */
/*****************************************************************************/
#if defined(INCL_STDIO)
#if defined(SEEK_SET)
#undef SEEK_SET
#endif
#if defined(SEEK_CUR)
#undef SEEK_CUR
#endif
#if defined(SEEK_END)
#undef SEEK_END
#endif
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#if defined(INCL_STDARG)
#include <varargs.h>
#undef INCL_STDARG
#undef va_start
#undef va_dcl
#define va_start(va_var, parm)\
  ((va_var)=(va_list)((char *)&(parm)+sizeof(parm)))
#endif

/*****************************************************************************/
/* RT does not support const or volatile                                     */
/*****************************************************************************/
#if !defined(const)
#define const
#endif

#if !defined(volatile)
#define volatile
#endif

#define RECOGNISED
#endif

#if !defined(RECOGNISED) && (defined(DOS) || defined(_MSC_VER) || defined(M_I86)) && !defined(CC_WS) && !defined(CC_C370)
/*****************************************************************************/
/* Assume this is MS, IBM C/2 or OS/2 2.0 SDK                                */
/*****************************************************************************/
typedef unsigned long        uint32_t;
typedef long                 int32_t;
typedef unsigned short       uint16_t;
typedef short                int16_t;
#define _MACHINE              "DOS PC"
#define _LITTLE_ENDIAN
#if defined(CC_MS)
#undef CC_MS
#endif
#define CC_MS                (1)
#if !defined(CC_IDK)
#define CC_IDK               (1)                           /* For PLIB       */
#endif
#if !defined(OS_OS2)
#if defined(OS_DOS)
#undef OS_DOS
#endif
#define OS_DOS               (1)
#endif
#define LINT_ARGS
typedef void *void_ptr_t;
#define RECOGNISED
#endif

#if !defined(RECOGNISED) && defined(__IBMC__)
/*****************************************************************************/
/* Assume this is IBM C for OS/2 2.0                                         */
/*****************************************************************************/
typedef unsigned long        uint32_t;
typedef long                 int32_t;
typedef unsigned short       uint16_t;
typedef short                int16_t;
#define _MACHINE              "OS/2 2 PC"
#define _LITTLE_ENDIAN
#if defined(CC_IBMC386)
#undef CC_IBMC386
#endif
#define  CC_IBMC386          (1)
#if defined(OS_OS2_2)
#undef OS_OS2_2
#endif
#define  OS_OS2_2            (1)
typedef void *void_ptr_t;
#define RECOGNISED
#endif

#if !defined(RECOGNISED) && defined(__TURBOC__) && \
 (__TURBOC__==0x100 || __TURBOC__==0x110)
/*****************************************************************************/
/* Turbo C for Atari ST                                                      */
/*****************************************************************************/
typedef unsigned long        uint32_t;
typedef long                 int32_t;
typedef unsigned             uint16_t;
typedef int                  int16_t;
#define _MACHINE             "Atari ST"
#define _BIG_ENDIAN
#if defined(CC_ATC)
#undef  CC_ATC
#endif
#define CC_ATC               (1)                           /* For PLIB       */
#if defined(OS_TOS)
#undef  OS_TOS
#endif
#define OS_TOS               (1)
#define LINT_ARGS
typedef void *void_ptr_t;
#define RECOGNISED

#if defined(INCL_MEMORY)
#include <string.h>
#undef INCL_MEMORY
#endif

#endif

#if !defined(RECOGNISED) && defined(__TURBOC__)
/*****************************************************************************/
/* Turbo C                                                                   */
/*****************************************************************************/
typedef unsigned long        uint32_t;
typedef long                 int32_t;
typedef unsigned             uint16_t;
typedef int                  int16_t;
#define _MACHINE              "DOS PC"
#define _LITTLE_ENDIAN

#if defined(CC_TURBO)
#undef CC_TURBO
#endif
#define CC_TURBO             (1)
#if defined(CC_TC)
#undef CC_TC
#endif
#define CC_TC                (1)                           /* For PLIB       */
#if defined(OS_DOS)
#undef OS_DOS
#endif
#define OS_DOS               (1)
#define LINT_ARGS
typedef void *void_ptr_t;
#define RECOGNISED

#if defined(INCL_MEMORY)
#include <mem.h>
#undef INCL_MEMORY
#endif

#endif

#if !defined(RECOGNISED) && defined(_IBMR2) && defined(_AIX) && defined(__GNUC__)
/*****************************************************************************/
/* Risc System/6000 and AIX V.3 running the GNU C compiler                   */
/*****************************************************************************/
typedef unsigned long uint32_t;
typedef long int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;

#if defined(CC_GNU)
#undef CC_GNU
#endif
#define CC_GNU              (1)                            /* GNU Compiler   */
#if defined(OS_AIX3_0)
#undef OS_AIX3_0
#endif
#define OS_AIX3_0           (1)                            /*Operating system*/
#if defined(__CHAR_UNSIGNED__)
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                 /* Are characters unsigned   */
#endif
#endif
#define NO_EXT_KEYS                                        /*Near/Far not ok */
#define _MACHINE             "Risc System/6000"            /*Machine string  */
#define _BIG_ENDIAN                                        /*Integer hi..lo  */

typedef void *void_ptr_t;
#define RECOGNISED
#endif

#if !defined(RECOGNISED) && defined(_IBMR2) && defined(_AIX)
/*****************************************************************************/
/* Risc System/6000 and AIX V.3 using XL C                                   */
/*****************************************************************************/
typedef unsigned long uint32_t;
typedef long int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;

#if defined(CC_XLC)
#undef CC_XLC
#endif
#define CC_XLC              (1)                            /*XL Compiler     */
#if defined(OS_AIX3_0)
#undef OS_AIX3_0
#endif
#define OS_AIX3_0           (1)                            /*Operating system*/
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                            /* chars unsigned */
#endif
#define NO_EXT_KEYS                                        /*Near/Far not ok */
#define _MACHINE             "Risc System/6000"            /*Machine string  */
#define _BIG_ENDIAN                                        /*Integer hi..lo  */

typedef void *void_ptr_t;
#define RECOGNISED
#endif

#if !defined(RECOGNISED) && defined(_I386) && defined(_AIX)
/*****************************************************************************/
/* PS/2 and AIX V1.2                                                         */
/*****************************************************************************/
typedef unsigned long uint32_t;
typedef long int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;

#if defined(CC_AIXPS2)
#undef CC_AIXPS2
#endif
#define CC_AIXPS2           (1)                            /*AIX PS/2       */
#if defined(OS_AIX1_2)
#undef OS_AIX1_2
#endif
#define OS_AIX1_2           (1)                            /*Operating system*/
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                            /*chars unsigned  */
#endif
#define NO_EXT_KEYS                                        /*Near/Far not ok */
#define _MACHINE             "AIX PS/2"                    /*Machine string  */
#define _LITTLE_ENDIAN                                     /*Integer hi..lo  */

typedef void *void_ptr_t;
#define RECOGNISED
#endif

/*****************************************************************************/
/* Whitesmiths C 370 Program Offering                                        */
/* I do not know of any predefined macros set by the Whitesmiths C compiler  */
/* so one must be set on the command line using                              */
/* VM:  CC <fn> <ft> ( define(CC_WS)                                         */
/* MVS: CC <fn> <ft> ( define(CC_WS) define(OS_MVS)                          */
/*****************************************************************************/
#if !defined(RECOGNISED) && defined(CC_WS)
typedef unsigned long uint32_t;
typedef long int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;

#if !defined(OS_MVS)
#if defined(OS_VM)
#undef OS_VM
#endif
#define OS_VM               (1)                            /*Operating system*/
#endif
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                            /*chars unsigned  */
#endif
#define NO_EXT_KEYS                                        /*Near/Far not ok */
#define _MACHINE             "IBM/370"                     /*Machine string  */
#define _BIG_ENDIAN                                        /*Integer hi..lo  */

typedef void *void_ptr_t;
#define RECOGNISED
#if defined(INCL_MEMORY)
#include <string.h>
#undef  INCL_MEMORY
#endif
#define SHORT_EXTERN_NAMES

/*****************************************************************************/
/* The Whitesmiths C compiler does not have a stddef.h file                  */
/* Instead it has a stdefs.h file which is nearly equivalent.                */
/*                                                                           */
/* Lacking in definition of fpos_t                                           */
/*****************************************************************************/
#if defined(INCL_STDDEF)
#include <stdefs.h>
#undef  INCL_STDDEF
typedef long fpos_t;                                       /* ftell / fseek  */
#endif

/*****************************************************************************/
/* string.h does not have a definition of strdup                             */
/*****************************************************************************/
#if defined(INCL_STRING)
#define strdup(s) (strcpy((char *)malloc(strlen(s)+1),s))
#endif

/*****************************************************************************/
/* stdio.h does not have a definition of NULL                                */
/*****************************************************************************/
#if defined(INCL_STDIO)
#if !defined(NULL)
#define NULL ((void *)0)
#endif
#endif

#endif

/*****************************************************************************/
/* IBM C/370                                                                 */
/* I do not know of any predefined macros set by the IBM compiler            */
/* so one must be set on the command line using                              */
/*                                                                           */
/* VM:  CC <fn> <ft> ( define(CC_C370)                                       */
/* MVS: CC <fn> <ft> ( define(CC_C370) define(OS_MVS)                        */
/*                                                                           */
/* CC_370 is also sometimes used                                             */
/*****************************************************************************/
#if !defined(RECOGNISED) && ( defined(CC_C370) || defined(CC_370) )
typedef unsigned long uint32_t;
typedef long int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;

#if defined(CC_C370)
#undef CC_C370
#endif
#define CC_C370             (1)
#if !defined(OS_MVS)
#if defined(OS_VM)
#undef OS_VM
#endif
#define OS_VM               (1)                            /*Operating system*/
#endif
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                            /*chars unsigned  */
#endif
#define NO_EXT_KEYS                                        /*Near/Far not ok */
#define _MACHINE             "IBM/370"                     /*Machine string  */
#define _BIG_ENDIAN                                        /*Integer hi..lo  */

typedef void *void_ptr_t;
#define RECOGNISED
#if defined(INCL_MEMORY)
#include <string.h>
#undef  INCL_MEMORY
#endif
#define SHORT_EXTERN_NAMES
#endif

/*****************************************************************************/
/* MetaWare C                                                                */
/*****************************************************************************/
#if defined(__HIGHC__)
#define RECOGNISED
pragma on (pointers_compatible);
#endif

#if defined(RECOGNISED)
#undef RECOGNISED
#else
/*****************************************************************************/
/* Unrecognised compiler                                                     */
/* Assume 32 bit ANSI C level and big endian                                 */
/*****************************************************************************/
#include <limits.h>

/*****************************************************************************/
/* Characters are unsigned if the minimum value a character can have is <0   */
/*****************************************************************************/
#if defined(CHAR_MIN) && CHAR_MIN < 0
#if !defined(_CHAR_UNSIGNED)
#define _CHAR_UNSIGNED      (1)                            /*chars unsigned  */
#endif
#endif

#if defined(INT_MAX) && INT_MAX == 0xffffffff
typedef unsigned int uint32_t;
typedef int int32_t
#else
typedef unsigned long uint32_t;
typedef long int32_t;
#endif

#if defined(INT_MAX) && INT_MAX == 32767
typedef unsigned uint16_t;
typedef int int16_t;
#else
typedef unsigned short uint16_t;
typedef short int16_t;
#endif

#define NO_EXT_KEYS                                /* Near / Far supported   */
#define _MACHINE             "Unknown"             /* Machine string         */
#define _BIG_ENDIAN                                /* Integers stored hi..lo */

typedef void *void_ptr_t;

#if defined(INCL_MEMORY)
#include <string.h>
#undef INCL_MEMORY
#endif

/*****************************************************************************/
/* C++ compilers can support long names                                      */
/*****************************************************************************/
#if !defined(__cplusplus)
#define SHORT_EXTERN_NAMES
#endif
#endif

/*****************************************************************************/
/* For cases where C is incompatible with C++, the following adjustments     */
/* are required                                                              */
/*****************************************************************************/
#if defined(__cplusplus)
#undef _NO_PROTO
#define volatile                                   /* No cfront support      */
#define START_C_SOURCE extern "C" {
#define END_C_SOURCE   }
#else
#define START_C_SOURCE
#define END_C_SOURCE
#endif

/*****************************************************************************/
/* For maximum portability, we define a macro before including libibm.h and  */
/* let libibm.h determine if that include file exists.  If it does, the      */
/* macros will still be defined at this point                                */
/*****************************************************************************/
#if defined(INCL_STDIO)
#include <stdio.h>
#endif

#if defined(INCL_MEMORY)
#include <string.h>
#include <memory.h>
#undef INCL_STRING
#endif

#if defined(INCL_STRING)
#include <string.h>
#endif

#if defined(INCL_STDDEF)
#include <stddef.h>
#endif

#if defined(INCL_STDLIB)
#include <stdlib.h>
#endif

#if defined(INCL_TIME)
#include <time.h>
#endif

#if defined(INCL_LIMITS)
#include <limits.h>
#endif

#if defined(INCL_STDARG)
#include <stdarg.h>
#endif

#if defined(INCL_CTYPE)
#include <ctype.h>
#endif

#if defined(INCL_ERRNO)
#include <errno.h>
#endif

#if !defined(TOKEN_PASTE)
/*****************************************************************************/
/* For ANSI compilers, the following pastes tokens together                  */
/*****************************************************************************/
#define TOKEN_PASTE(a,b) a##b
#define TOKEN_QUOTE(a)   #a
#endif


#define   EOS   ((char)'\0')                               /* End of string  */
#define   EOL   ((char)'\n')                               /* End of line    */

/*****************************************************************************/
/* Values for bool_t variables                                               */
/*****************************************************************************/
#if !defined(TRUE)
#define   TRUE   ((bool_t)0x1)
#endif
#if !defined(ON)
#define   ON     ((bool_t)0x1)
#endif
#if !defined(FALSE)
#define   FALSE  ((bool_t)0x0)
#endif
#if !defined(OFF)
#define   OFF    ((bool_t)0x0)
#endif

#if !defined(ERROR)
#define   ERROR   -1
#endif

#define _PI 3.14159265358979323846                         /* PI             */

#define _2_PI 6.28318530717958647692                       /* 2*PI           */
#define _PI_2 1.57079632679489661923                       /* PI/2           */
#define _1_PI .31830988618379067154                        /* 1/PI           */
#define _SQ2 1.41421356237309504880                        /* sqrt(2)        */
#define _SQ2_2 .70710678118654752440                       /* sqrt(2)/2      */
#define _LN2_2 .3465735902799725                           /* ln(2)/2        */

/*****************************************************************************/
/*                    Useful #defined Functions                              */
/*****************************************************************************/

/*****************************************************************************/
/* Number of elements in an array.                                           */
/*****************************************************************************/
#define COUNTOF( A ) ( sizeof( A ) / sizeof( A[ 0 ] ) )

/*****************************************************************************/
/* Pointer to the last element of an array.                                  */
/*****************************************************************************/
#define LASTP( A ) ( &A[ countof( A ) - 1 ] )

/*****************************************************************************/
/* Pointer to just past the end of an array.                                 */
/*****************************************************************************/
#define PASTP( A ) ( &A[ countof( A ) ] )

/*****************************************************************************/
/* Smaller of two values.                                                    */
/*****************************************************************************/
#if !defined(MIN)
#define MIN( M, N ) ( ( ( M ) < ( N ) ) ? ( M ) : ( N ) )
#endif

/*****************************************************************************/
/* Larger of two values                                                     */
/*****************************************************************************/
#if !defined(MAX)
#define MAX( M, N ) ( ( ( M ) > ( N ) ) ? ( M ) : ( N ) )
#endif

/*****************************************************************************/
/* TRUE if A <= B <= C                                                       */
/*****************************************************************************/
#define _INRANGE_( A, B, C ) ( ( A ) <= ( B ) && ( B ) <= ( C ) )

/*****************************************************************************/
/* TRUE if A < B <= C                                                        */
/*****************************************************************************/
#define INRANGE_( A, B, C ) ( ( A ) < ( B ) && ( B ) <= ( C ) )

/*****************************************************************************/
/* TRUE if A <= B < C                                                       */
/*****************************************************************************/
#define _INRANGE( A, B, C ) ( ( A ) <= ( B ) && ( B ) < ( C ) )

/*****************************************************************************/
/* TRUE if A < B < C                                                         */
/*****************************************************************************/
#define INRANGE( A, B, C ) ( ( A ) < ( B ) && ( B ) < ( C ) )

#ifndef ABS
#define ABS(v) ((v<0)?(-(v)):(v))
#endif

#endif
